// AIMC 2026 - Main Document
// Conference on AI Music Creativity

#import "aimc2026_template.typ": *

#show: aimc2026.with(
  font: ("Times New Roman", "Stix Two Text"),
  title: [Typst Template for the Conference on AI Music Creativity (AIMC) 2026],
  authors: (
    (
      name: [First Author#thanks[Use footnote for providing further information about author (webpage, alternative address)---_not_ for acknowledging funding agencies.]],
      affiliation: [Department of Music \ Strawberry-Raspberry University \ Pittsburgh, PA 15213],
      email: "rhino@music.strawberry-raspberry.edu",
    ),
    // Add more authors as needed:
    (
      name: [Coauthor],
      affiliation: [Affiliation \ Address line 1 \ Address line 2],
      email: "email@example.com",
    ),
    // (
    //   name: [Coauthor],
    //   affiliation: [Affiliation \ Address line 1 \ Address line 2],
    //   email: "email@example.com",
    // ),
    // (
    //   name: [Coauthor],
    //   affiliation: [Affiliation \ Address line 1 \ Address line 2],
    //   email: "email@example.com",
    // ),
    // (
    //   name: [Coauthor],
    //   affiliation: [Affiliation \ Address line 1 \ Address line 2],
    //   email: "email@example.com",
    // ),
    // (
    //   name: [Coauthor],
    //   affiliation: [Affiliation \ Address line 1 \ Address line 2],
    //   email: "email@example.com",
    // ),

  ),
  abstract: [
    The abstract paragraph should be indented 1.5 cm on both the left- and right-hand margins.
    Use 10-point type, with a vertical spacing (leading) of 11 points.
    The word *Abstract* must be centered, bold, and in point size 12. Two line spaces precede the abstract. The abstract must be limited to one paragraph.
  ],
)

#let custom_hyphenation_words = (
  "place-cus-tom-hy-phe-na-tions-here",
  "foo-baz",
)

// do not change this:
#show: it => custom_hyphenation_words.fold(it, (it, word) => {
  show word.replace("-", ""): word.replace("-", sym.hyph.soft)
  it
})




/* ############################# *\
|* #####.  Main Text Body: ##### *|
\* ############################# */


= Submission of papers to AIMC 2026 <sec:submissions>

AIMC requires electronic submissions. You can access the submission site via this year's conference website: #link("https://aimc2026.org/").

Please read the instructions below carefully and follow them precisely.

When submitting, please omit all author details.

= General formatting instructions <sec:general_instructions>

The page must be DIN A4 size with 2~cm margins on all sides.
The column separation is 8~mm. Use 10-point type with 11-point vertical spacing (leading).
Times New Roman is the preferred typeface.
A fallback option for documents hosted on #link("typst.app") is "Stix Two Text".
Paragraphs should be separated by $frac(1,2, style: "skewed")$ line space (5.5 points), with no indentation.

The paper title should be 17-point, in initial caps/lower case, bold, centered.
All pages should start at 2~cm from the
top of the page.

In the final version, the authors' names should be in bold, with each name centered above the corresponding address. The lead author's name should be listed first (leftmost), followed by the co-authors' names (if the addresses are different). If there is only one co-author, list the author and co-author side by side.

Please pay special attention to the instructions in @sec:others regarding figures, tables, acknowledgments, and references.

= Headings: first level <sec:headings>

All headings should be flush left.
First-level headings should be bold and written in all caps in 10-point type.

== Headings: second level <sec:headings_second>

Second-level headings should be bold and in 10-point type.

=== Headings: third level <sec:headings_third>

Third-level headings should be in 10-point type.

= Citations, figures, tables, references <sec:others>

== Citations within the text <sec:citations>

Typst has built-in citation support. Use `@key` for citations that appear in the text, like @artiexample, @confexample and @bookexample.

Since the submission process is double-blind, refer to your own published work in the third person. That is, use "In the previous work of Jones et al. (Jones et al., 2020)," not "In our previous work (Jones et al., 2020)."

If you cite your other papers that are not widely available (e.g., a journal paper under review), use anonymous author names in the citation, e.g., an author of the form "A. Anonymous".

== Figures <sec:figures>

#figure(
  image("images/single_column_figure.pdf", width: 100%),
  caption: [
    Single column figures are placed using the `figure` function.
    The column width is 17 cm (6.69~in).
  ],
) <fig:single_column>

#figure(
  scope: "parent",
  placement: top,
  image("images/double_column_figure.png", width: 100%),
  caption: [
    Figures can span both columns using `scope: "parent"`.
    The double column width is 17~cm (6.69~in).
  ],
) <fig:double_column>

All artwork must be neat, clean, and legible.
Lines should be dark enough for purposes of reproduction.
The figure number and caption always appear after the figure.
Place one line space before the figure caption and one line space after the figure. Figure captions should be in lowercase, except for the first word and proper nouns. Figures are numbered consecutively.

You may use color figures.
However, it is best for the figure captions and the paper body to be legible if the paper is printed in either black and white or color.

We suggest using the `image` function from Typst. Always specify the width as a percentage of the line width:

```typst
#figure(
  image("myfile.pdf", width: 80%),
  caption: [My caption],
)
```

== Tables <sec:tables>

All tables must be centered, neat, clean and legible.  The table number and title always appear before the table.
See @tab:sample-table.

Place one line space before the table title and after both the title and after the table.
The table title must be lowercase, except for the first word and proper nouns.
Tables are numbered consecutively.

Note that publication-quality tables _do not contain vertical rules_.

#figure(
  table(
    columns: 3,
    stroke: none,
    table.hline(),
    table.header(table.cell(colspan: 2)[*Part*], []),
    table.hline(stroke: 0.5pt, start: 0, end: 2),
    [Name],     [Description],     [Size in #sym.mu\m],
    table.hline(stroke: 0.5pt),
    [Dendrite], [Input terminal],  [$~100$],
    [Axon],     [Output terminal], [$~10$],
    [Soma],     [Cell body],       [up to 10#super[6]],
    table.hline(),
  ),
  caption: [Sample table],
) <tab:sample-table>

== Hyphenation <sec:hyphenation>

Typst handles hyphenation automatically.
To suggest custom hyphenation points for specific words, add them to the `custom_hyphenation_words` list in the preamble.


== Internal references <sec:references>

Use Typst's built-in referencing with labels and `@label` syntax.

Example:
@fig:single_column, @sec:figures, @tab:sample-table.

== Footnotes <sec:footnotes>

Footnotes should be used sparingly. If you do require a footnote, indicate footnotes with a number#footnote[Sample of the first footnote.] in the text. Place the footnotes at the bottom of the page on which they appear.

Note that footnotes are properly typeset _after_ punctuation marks.#footnote[As in this example.]

= Final instructions <sec:final_instructions>

Do not modify any formatting parameters in the style files.
In particular, do not modify the page margins, nor the font sizes (except perhaps in the _References_ section; see below).
Please note that pages should be numbered.

= Preparing PDF files <sec:pdf_files>

Your PDF file must only contain Type 1 or Embedded TrueType fonts.

+ #link("typst.app") can be used to collaborate.
+ Visual Studio Code provides various Typst extensions. This template works out of the box with the #link("https://marketplace.visualstudio.com/items?itemName=myriad-dreamin.tinymist", "Tinymist Typst") extension.
+ You can also install Typst locally and compile with `typst compile`.
+ Use vector graphics (PDF, SVG) for figures when possible.

#nonumbering[= Author Declarations]

Author declarations should include conflicts of interest, ethical issues, and comments on the use of AI.

Use unnumbered first level headings for the acknowledgments. All acknowledgments go at the end of the paper before the list of references.

Do *not* include acknowledgments in the anonymized submission, only in the final paper.


#set text(size: 9pt)
// #show link: it => text(fill: black, raw(it.body.text))
#bibliography("references.bib")

References follow the author declarations.
Use unnumbered first-level heading for the references.
The citation style should follow APA.
It is permissible to reduce the font size to 9 point when listing the references.


