// AIMC 2026 Typst Template
// Conference on AI Music Creativity
// Copyright (c) 2026 Audiocommunication Group, TU Berlin
// Licensed under the MIT License.

// Conference information
#let aimc-ordinal = [7#super[th]]
#let aimc-year = "2026"
#let aimc-dates = [September 16#super[th]--18#super[th]]
#let aimc-location = "Berlin, Germany"

#let aimc-notice = [
  Proceedings of the #aimc-ordinal Conference on AI Music Creativity
  (AIMC #aimc-year),
  #aimc-location, #aimc-dates
]

// State for author thanks footnote
#let thanks-content = state("thanks-content", none)

// Main document template
#let aimc2026(
  font: "Stix Two Text",
  title: none,
  authors: (),
  abstract: none,
  body,
) = {
  // Document settings
  set document(title: title)

  // Page setup: A4 with 2cm margins (columns handled manually for first page)
  set page(
    paper: "a4",
    margin: (top: 2cm, bottom: 2cm, left: 2cm, right: 2cm),
    header: context {
      if counter(page).get().first() == 1 {
        set text(size: 9pt)
        set align(center)
        move(dy: -4mm, aimc-notice)
      }
    },
    numbering: "1",
  )

  set text(
    font: font,
    size: 10pt,
  )

  set par(
    justify: true,
    leading: 0.55em,  // 11pt leading for 10pt text
    spacing: 1em,     // paragraph spacing
    first-line-indent: 0pt,
  )

  // Heading styles
  set heading(numbering: "1.")

  show heading.where(level: 1): it => {
    set text(size: 10pt, weight: "bold")
    block(
      above: 2em,
      below: 1em,
      {
        if it.numbering != none {
          counter(heading).display("1")
          h(0.3em)
        }
        upper(it.body)
      }
    )
  }

  show heading.where(level: 2): it => {
    set text(size: 10pt, weight: "bold")
    block(
      above: 1.8em,
      {
        if it.numbering != none {
          counter(heading).display("1.1")
          h(0.3em)
        }
        it.body
      }
    )
  }

  show heading.where(level: 3): it => {
    set text(size: 10pt, weight: "regular")
    block(
      above: 1.5em,
      {
        if it.numbering != none {
          counter(heading).display("1.1.1")
          h(0.3em)
        }
        it.body
      }
    )
  }

  // Figure and table captions
  set figure(gap: 0.7em)
  set figure.caption(separator: [. ])

  // Place table captions above tables
  show figure.where(kind: table): set figure.caption(position: top)

  // List formatting
  set list(indent: 0.5em)
  set enum(indent: 0.5em)

  // Link styling
  show link: it => text(fill: blue, raw(it.body.text))
  
  // Bibliography
  set bibliography(style: "apa")
  
  // Inside the bibliography, render links in black
  show bibliography: it => {
    show link: it => text(fill: black, raw(it.body.text))
    it
  }

  // Title block (full width, before columns)
  block(
    width: 100%,
    {
      // Title
      set text(size: 17pt, weight: "bold")
      set align(center)
      v(0.1in)
      title
      v(3mm)
    }
  )

  // Authors
  block(
    width: 100%,
    {
      set align(center)
      set text(weight: "bold")
      set par(leading: 0.44em, spacing: 0.44em)
      let author-block(author) = [
        #author.name
        #if "affiliation" in author {
          [\ #text(weight: "regular", author.affiliation)]
        }
        #if "email" in author {
          [\ #text(weight: "regular", raw(author.email))]
        }
      ]
      let cols = calc.min(authors.len(), 3)
      grid(
        columns: cols,
        column-gutter: 2em,
        row-gutter: 1.5em,
        ..authors.map(author-block)
      )
      v(18pt)
    }
  )

  // Abstract
  if abstract != none {
    block(
      width: 100%,
      {
        align(center, text(size: 12pt, weight: "bold")[Abstract])
        set par(leading: 0.4em, spacing: 0.4em)
        pad(
          left: 1.5cm,
          right: 1.5cm,
          abstract
        )
        v(22pt)
      }
    )
  }

  // Main body in two columns
  columns(2, gutter: 8mm, {
    // Display thanks footnote at bottom of first column
    context {
      let tc = thanks-content.get()
      if tc != none {
        place(
          bottom + left,
          float: true,
          clearance: 1em,
          block(width: 100%, {
            line(length: 30%, stroke: 0.5pt)
            v(0.3em)
            text(size: 9pt)[#super[\*]#tc]
          })
        )
      }
    }
    body
  })
}

// Helper function for author footnotes
#let thanks(content) = {
  thanks-content.update(content)
  [#super[\*]]
}

// Acknowledgments environment
#let nonumbering(body) = {
  set heading(numbering: none)
  body
}
